/*==============================================================================
PART 3: Table A4, Panels A and B
==============================================================================
Purpose:
This script generates Table A4:
- Panel A: Summary statistics for deposit franchise value for all banks across three periods
- Panel B: Summary statistics for deposit franchise value for large banks (assets >= $100 billion

Input:
- $path_clean/analysis_ready_data.dta (Master dataset containing deposit
  franchise value variables)

Output:
- $path_tables/table_a4_panel_a.tex (LaTeX file containing Table A4, Panel A)
- $path_tables/table_a4_panel_b.tex (LaTeX file containing Table A4, Panel B)

Last updated: July 03, 2025
==============================================================================*/

display "--- Starting Part 3D: Table A4: Deposit Franchise Value Statistics ---"

*-------------------------------------------------------------------------------
* Panel A: Deposit Franchise Value Summary Statistics, All Banks
*-------------------------------------------------------------------------------
* Purpose: Calculate and format summary statistics for deposit franchise value
* for all banks across three periods, outputting to a LaTeX table.

* Clear any previously stored estimation results
eststo clear

* Calculate summary statistics for all banks (Dec 2021)
* Condition: period is dec2021
eststo: estpost summarize DI_value DU_value DF_value if period == "dec2021", d

* Calculate summary statistics for all banks (Feb 2023)
* Condition: period is feb2023, DI_value is not missing (sample selection criterion)
eststo: estpost summarize DI_value DU_value DF_value if period == "feb2023" & !mi(DI_value), d

* Calculate summary statistics for all banks (Feb 2024)
* Condition: period is feb2024, DI_value is not missing (sample selection criterion)
eststo: estpost summarize DI_value DU_value DF_value if period == "feb2024" & !mi(DI_value), d

* Format and export the stored summary statistics to a LaTeX table
* The esttab command combines the results from the 3 eststo commands above
* into a single table with 3 columns (one for each period).
esttab using "$path_tables/table_a4_panel_a.tex",  main(mean) aux(sd) nonumber  ///
    prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi}" "\begin{tabular*}{0.75\textwidth}{@{\hskip\tabcolsep\extracolsep\fill}l*{3}{c}}" ///
    "\hline\hline" "&\multicolumn{3}{c}{All banks}" "\\\cmidrule(lr){2-4}" "Deposit Franchise Value&\multicolumn{1}{c}{Dec 2021}&\multicolumn{1}{c}{Feb 2023}&\multicolumn{1}{c}{Feb 2024}" "\\\cmidrule(lr){2-2}" "\cmidrule(lr){3-3}" "\cmidrule(lr){4-4}" "&\multicolumn{1}{c}{(1)}" "&\multicolumn{1}{c}{(2)}" "&\multicolumn{1}{c}{(3)}" "\\") ///
    width(0.8\textwidth) nogaps ///
    b(%8.2f) sfmt(%12.0fc %9.2fc) order(DI_value DU_value DF_value) ///
    coeflabels(DI_value "$ DF\_I $ (Insured)" DU_value "$ DF\_U $ (Uninsured)" DF_value "$ DF_I + DF_U $" _cons "Constant") ///
    noobs scalars("N Obs.") ///
    msign($-$) replace nonotes nomtitles substitute(\_ _) starlevels(* 0.10 ** 0.05 *** 0.01) ///
    postfoot("\hline\hline \end{tabular*}}")

display "--- Table A4, Panel A created: $path_tables/table_a4_panel_a.tex ---"

*-------------------------------------------------------------------------------
* Panel B: Deposit Franchise Value Summary Statistics, Large Banks
*-------------------------------------------------------------------------------
* Purpose: Calculate and format summary statistics for deposit franchise value
* for large banks across three periods, outputting to a LaTeX table.

* Clear any previously stored estimation results
eststo clear

* Calculate summary statistics for large banks (assets >= $100 billion) (Dec 2021)
* Condition: period is dec2021, assets_bill >= 100
eststo: estpost summarize DI_value DU_value DF_value if period == "dec2021" & assets_bill>=100, d

* Calculate summary statistics for large banks (assets >= $100 billion) (Feb 2023)
* Condition: period is feb2023, DI_value not missing, assets_bill >= 100
eststo: estpost summarize DI_value DU_value DF_value if period == "feb2023" & !mi(DI_value) & assets_bill>=100, d

* Calculate summary statistics for large banks (assets >= $100 billion) (Feb 2024)
* Condition: period is feb2024, DI_value not missing, assets_bill >= 100
eststo: estpost summarize DI_value DU_value DF_value if period == "feb2024" & !mi(DI_value) & assets_bill>=100, d

* Format and export the stored summary statistics to a LaTeX table
* The esttab command combines the results from the 3 eststo commands above
* into a single table with 3 columns (one for each period).
esttab using "$path_tables/table_a4_panel_b.tex",  main(mean) aux(sd) nonumber  ///
    prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi}" "\begin{tabular*}{0.75\textwidth}{@{\hskip\tabcolsep\extracolsep\fill}l*{3}{c}}" ///
    "\hline\hline" "&\multicolumn{3}{c}{Large banks}" "\\\cmidrule(lr){2-4}" "Deposit Franchise  Value&\multicolumn{1}{c}{Dec 2021}&\multicolumn{1}{c}{Feb 2023}&\multicolumn{1}{c}{Feb 2024}" "\\\cmidrule(lr){2-2}" "\cmidrule(lr){3-3}" "\cmidrule(lr){4-4}" "&\multicolumn{1}{c}{(1)}" "&\multicolumn{1}{c}{(2)}"   "&\multicolumn{1}{c}{(3)}" "\\") ///
    width(0.8\textwidth) nogaps ///
    b(%8.2f) sfmt(%12.0fc %9.2fc) order(DI_value DU_value DF_value) ///
    coeflabels(DI_value "$ DF\_I $ (Insured)" DU_value "$ DF\_U $ (Uninsured)" DF_value "$ DF_I + DF_U $" _cons "Constant") ///
    noobs scalars("N Obs.") ///
    msign($-$) replace nonotes nomtitles substitute(\_ _) starlevels(* 0.10 ** 0.05 *** 0.01) ///
    postfoot("\hline\hline \end{tabular*}}")


display "--- Table A4, Panel B created: $path_tables/table_a4_panel_b.tex ---"

display "--- Finished Part 3D: Table A4: Deposit Franchise Value Statistics ---"
